@extends( 'layouts.admin' )



@section( 'styles' )

@endsection



@section( 'content' )

<!-- ============================================================== -->

<!-- Start right Content here -->

<!-- ============================================================== -->

<div class="content-page">

	<!-- Start content -->

	<div class="content">

		<div class="container-fluid">

			<div class="row">

				<div class="col-sm-12">

					<div class="page-title-box">

						<div class="row align-items-center">

							<div class="col-md-8">

								<h4 class="page-title mb-0">Registered Students</h4>

								<ol class="breadcrumb m-0">

									<li class="breadcrumb-item"><a href="#">Student Module</a>
									</li>

									<li class="breadcrumb-item active" aria-current="page"> Students List</li>

								</ol>

							</div>

							<div class="col-md-4">

								<div class="float-right d-none d-md-block">

									<div class="dropdown">

										<!-- <button class="btn btn-success btn-rounded" type="button"  data-toggle="modal" data-target="#addGradeModal">

                                          <i class="fa fa-plus"></i> Add New Grade

                                      </button> -->



									</div>

								</div>

							</div>

						</div>



					</div>

				</div>

			</div>

			<!-- end row -->

			<div class="row">

				<div class="col-lg-12">

					<div class="card">

						<div class="card-body">



							<!-- Nav tabs -->
							<ul class="nav nav-tabs" role="tablist">
								@foreach($grades as $gg)
								<li class="nav-item">
									<a class="nav-link @if($loop->iteration == 1) active @endif" data-toggle="tab" href="#grade_{{$gg->id}}" role="tab" aria-selected="true">
                                                    <span class="d-none d-md-block">{{$gg->name}}</span><span class="d-block d-md-none"><i class="mdi mdi-home-variant h5"></i></span>
                                                </a>

								</li>
								@endforeach

							</ul>

							<!-- Tab panes -->
							<div class="tab-content">

								@foreach($grades as $ggg)
								<div class="tab-pane p-3 @if($loop->iteration == 1 ) active @endif" id="grade_{{$ggg->id}}" role="tabpanel">
									<p class="font-14 mb-0">
										<div class="table-responsive mt-4">

											<table class="table table-striped table-hover mb-0">

												<thead>

													<tr>

														<th scope="col">Reg # </th>
														<th scope="col">Student Name</th>
														<th scope="col">Grades</th>
														<th scope="col">Courses</th>
														<th scope="col">Applied Date</th>

														<th scope="col">Registration Fee</th>

														<th scope="col">Parent/Guardian</th>
														<th scope="col">Contact #</th>
														<th scope="col" colspan="2">Action</th>

													</tr>

												</thead>

												<tbody>
													@foreach($students->where('grade_id' , $ggg->id) as $stu)
													<tr>
														<th scope="row">#{{$stu->id}}</th>
														<td> <strong>{{$stu->student->family_name}} {{$stu->student->given_name}}</strong> </td>
														<td align="center">{{$stu->grade->name}}</td>
														<td align="center"><span class="badge badge-success">{{$stu->course->name}}</span>
														</td>
														<td align="center">{{$stu->created_at}}</td>
														<td align="center">${{$stu->total_paid}}</td>
														<td>{{$stu->student->parent->name}}</td>
														<td>{{$stu->student->cell_no}}</td>
														<td>
															<div>
																<a href="{{ route('admin.studentdetail' , $stu->id)}}"class="text-success"><i class="mdi mdi-account-search h4"></i></a>
																<a href="#" class="text-danger"><i class="mdi mdi-delete-forever h4"></i></a>
															</div>
														</td>

													</tr>
													@endforeach

												</tbody>

											</table>

										</div>

										<nav aria-label="Page navigation example">
											<ul class="pagination justify-content-end mb-0  m-t-15">
												<li class="page-item disabled">
													<a class="page-link" href="#" tabindex="-1">Previous</a>
												</li>
												<li class="page-item"><a class="page-link" href="#">1</a>
												</li>
												<li class="page-item"><a class="page-link" href="#">2</a>
												</li>
												<li class="page-item"><a class="page-link" href="#">3</a>
												</li>
												<li class="page-item">
													<a class="page-link" href="#">Next</a>
												</li>
											</ul>
										</nav>
									</p>
								</div>
								@endforeach

							</div>

						</div>




					</div>

				</div>

			</div>

			<!-- end row -->



		</div>
		<!-- container-fluid -->



	</div>
	<!-- content -->



	<footer class="footer">

		© 2020 - 2021 The Educators Academy

	</footer>

</div>





<!-- ============================================================== -->

<!-- End Right content here -->

<!-- ============================================================== -->



@endsection



@section( 'scripts' )



@endsection
